function Fig2(YMatrix1, YMatrix2)
%CREATEFIGURE(YMatrix1, YMatrix2)
%  YMATRIX1:  matrix of semilogy y data
%  YMATRIX2:  matrix of semilogy y data

%  Auto-generated by MATLAB on 18-May-2023 13:04:27

% Create figure
figure('WindowState','maximized');

% Create subplot
subplot1 = subplot(2,1,1);
hold(subplot1,'on');

% Create multiple line objects using matrix input to semilogy
semilogy1 = semilogy(YMatrix1,'LineWidth',4.5);
set(semilogy1(1),'DisplayName','NNAG');
set(semilogy1(2),'DisplayName','Per-FE-C');
set(semilogy1(3),...
    'DisplayName','Perturbed Gradient Descent + Gaussian Noise');

% Create ylabel
ylabel('Logistic Loss');

% Create xlabel
xlabel('Epoch');

hold(subplot1,'off');
% Set the remaining axes properties
set(subplot1,'FontName','Times New Roman','FontSize',36,'LineWidth',3.5,...
    'XGrid','on','XTickLabel',...
    {'0','10','20','30','40','50','60','70','80','90','100'},'YGrid','on',...
    'YMinorTick','on','YScale','log');
% Create legend
legend1 = legend(subplot1,'show');
set(legend1,...
    'Position',[0.140008991126752 0.623392727099336 0.408792670733976 0.130096266231435],...
    'Interpreter','latex');

% Create subplot
subplot2 = subplot(2,1,2);
hold(subplot2,'on');

% Create multiple line objects using matrix input to semilogy
semilogy2 = semilogy(YMatrix2,'LineWidth',4.5);
set(semilogy2(1),'DisplayName','SGD','LineWidth',3,...
    'Color',[0.494117647058824 0.184313725490196 0.556862745098039]);
set(semilogy2(2),'DisplayName','SVRG',...
    'Color',[0.850980392156863 0.325490196078431 0.0980392156862745]);
set(semilogy2(3),'DisplayName','NNAG + SGD Gradients',...
    'Color',[0 0.447058823529412 0.741176470588235]);
set(semilogy2(4),'DisplayName','NNAG + SVRG Gradients',...
    'Color',[0.466666666666667 0.674509803921569 0.188235294117647]);

% Create ylabel
ylabel('Logistic Loss');

% Create xlabel
xlabel('Epoch');

hold(subplot2,'off');
% Set the remaining axes properties
set(subplot2,'FontName','Times New Roman','FontSize',36,'LineWidth',3.5,...
    'XGrid','on','XTickLabel',...
    {'0','10','20','30','40','50','60','70','80','90','100'},'YGrid','on',...
    'YMinorTick','on','YScale','log');
% Create legend
legend2 = legend(subplot2,'show');
set(legend2,...
    'Position',[0.573541395586369 0.151429212583272 0.323211762963272 0.087978615990297],...
    'NumColumns',2,...
    'Interpreter','latex');

